#!/usr/bin/python3
# -*- coding : utf-8 -*-


import gi
import os
import csv
import subprocess

gi.require_version("Gtk", "3.0")
gi.require_version('GdkPixbuf', '2.0')
from gi.repository import Gtk, Gdk
from gi.repository import GdkPixbuf
from gi.repository.GdkPixbuf import Pixbuf


# --- CSS ---

screen = Gdk.Screen.get_default()
provider = Gtk.CssProvider()

style_context = Gtk.StyleContext()
style_context.add_provider_for_screen(screen, provider, Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION)

css = b"""
#LIST_BG {
color: black; background: #FFFFFF;
}
"""   # use prefix `b` or `.encode()` to create `bytes`

provider.load_from_data(css)

# ---


filename =os.path.dirname(__file__)+'/ICONS.csv'
with open(filename, encoding='utf8', newline='') as f:
    csvreader = csv.reader(f)
    icons = [row for row in csvreader]
#icons = [["xclock","CLOCK","ICON.png"],["xlogo","XLOGO","ICON2.png"]]


class IconViewWindow(Gtk.Window):
    def __init__(self):
        super().__init__(title="Program Manager")
        self.set_default_size(480, 272)

        appicon = GdkPixbuf.Pixbuf.new_from_file(os.path.dirname(__file__)+"/ICON.png")
        self.set_icon_list([appicon])

        icon_window = Gtk.ScrolledWindow()

        liststore = Gtk.ListStore(Pixbuf, str)
        iconview = Gtk.IconView.new()
        iconview.set_model(liststore)
        iconview.set_pixbuf_column(0)
        iconview.set_text_column(1)

        iconview.set_name("LIST_BG")

        cnt=0
        for icon in icons:
            CMD,LABEL,ICON=icons[cnt]
            pixbuf = GdkPixbuf.Pixbuf.new_from_file(os.path.dirname(__file__)+"/"+ICON)
            liststore.append([pixbuf, LABEL])
            cnt+=1
        icon_window.add(iconview)
        self.add(icon_window)


        def FUNC(param1,param2):
            print(param1)
            print(param2)
            print(param2.get_indices())
            CMD,LABEL,ICON=icons[int(param2.get_indices()[0])]  #何故か要素数1のリストで返ってくるので、0番を指定
            subprocess.Popen(CMD, shell=True)


        iconview.connect("item_activated",FUNC)

win = IconViewWindow()
win.connect("destroy", Gtk.main_quit)
win.show_all()
Gtk.main()
