#!/usr/bin/python3
# -*- coding : utf-8 -*-

import gi
import os
import sys
import random
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk, Gdk

TIPS=          ["All your base are\nbelong to us."]
TIPS.insert(100,"Turn right at\nthe indian.")
TIPS.insert(100,"Windows was dead.")
TIPS.insert(100,"Do you like\nClassic Windows?")
TIPS.insert(100,"No inspiration.")
TIPS.insert(100,"Tanuki is cute.\nYou should love tanuki.")
TIPS.insert(100,"Blah blah blah blah blah blah\nBlah blah blah blah blah blah\nBlah blah blah blah blah blah\nBlah blah blah blah blah blah\n")

# --- CSS ---

screen = Gdk.Screen.get_default()
provider = Gtk.CssProvider()

style_context = Gtk.StyleContext()
style_context.add_provider_for_screen(screen, provider, Gtk.STYLE_PROVIDER_PRIORITY_APPLICATION)

css = b"""
#LIST_BG {
color: black; background: #FFFFC0;
border-top-color: #FFFFC0;
border-left-color: #FFFFC0;
border-right-color: #FFFFC0;
border-bottom-color: #FFFFC0;
}
"""   # use prefix `b` or `.encode()` to create `bytes`

provider.load_from_data(css)

# ---

class FormWindow(Gtk.Window):
    def __init__(self):
        super().__init__(title="Welcome")
        self.set_border_width(16)
        self.set_position(Gtk.WindowPosition.CENTER)
        
        # グリッドの作成
        grid = Gtk.Grid()
        grid.set_column_spacing(16)
        grid.set_row_spacing(16)
        self.add(grid)

        TOP_IMAGE = Gtk.Image()
        TOP_IMAGE.set_from_file(os.path.dirname(__file__)+"/TOP.png")
        grid.attach(TOP_IMAGE, 0, 0, 1, 1)

        BOX = Gtk.Grid()

        hbox = Gtk.Box(orientation=Gtk.Orientation.HORIZONTAL, spacing=0)   #うちの環境では0じゃないと灰色の帯が出てしまった
        BOX.add(hbox)

        SPACE1 = Gtk.Label(label="  ", xalign=0)
        hbox.pack_start(SPACE1, True, True, 0)

        vbox = Gtk.Box(orientation=Gtk.Orientation.VERTICAL)
        hbox.pack_start(vbox, True, True, 0)

        SPACE2 = Gtk.Label(label="  ", xalign=0)
        vbox.pack_start(SPACE2, True, True, 0)

        ICON = Gtk.Image()
        print(os.path.dirname(__file__)+"/ICON.png")
        ICON.set_from_file(os.path.dirname(__file__)+"/ICON.png")
        vbox.pack_start(ICON, False, True, 0)

        SPACE3 = Gtk.Label(label="  ", xalign=0)
        vbox.pack_start(SPACE3, True, True, 0)
        SPACE4 = Gtk.Label(label="  ", xalign=0) #超バッドノウハウ
        vbox.pack_start(SPACE4, True, True, 0)

        SPACE5 = Gtk.Label(label="  ", xalign=0)
        hbox.pack_start(SPACE5, True, True, 0)

        vbox = Gtk.Box(orientation=Gtk.Orientation.VERTICAL)
        hbox.pack_start(vbox, True, True, 0)

        LABEL1 = Gtk.Label(label="\nDid you know...\n", xalign=0)
        vbox.pack_start(LABEL1, True, True, 0)

        LABEL2 = Gtk.Label(label=TIPS[random.randrange(0,len(TIPS))], xalign=0)
        vbox.pack_start(LABEL2, True, True, 0)

        grid.attach(BOX,0,1,1,5)

        SPACE1.set_name('LIST_BG')
        SPACE2.set_name('LIST_BG')
        SPACE3.set_name('LIST_BG')
        SPACE4.set_name('LIST_BG')
        SPACE5.set_name('LIST_BG')
        ICON.set_name('LIST_BG')
        LABEL1.set_name('LIST_BG')
        LABEL2.set_name('LIST_BG')
        BOX.set_name('LIST_BG')
        
        BUTTON1 = Gtk.Button(label="What's New")
        BUTTON1.connect("clicked", self.NOTHING)
        grid.attach(BUTTON1, 1, 1, 1, 1)

        BUTTON2 = Gtk.Button(label="Online Registration")
        BUTTON2.connect("clicked", self.NOTHING)
        grid.attach(BUTTON2, 1, 2, 1, 1)

        BUTTON4 = Gtk.Button(label="Close")
        BUTTON4.connect("clicked", self.CLOSE)
        grid.attach(BUTTON4, 1, 5, 1, 1)
        
    def NOTHING(self, widget):
        print("NOTHING YET!")

    def CLOSE(self,widget):
        sys.exit()

win = FormWindow()
win.connect("destroy", Gtk.main_quit)
win.show_all()
Gtk.main()
