#!/usr/bin/python3
# -*- coding : utf-8 -*-

import gi
import os
import subprocess
import sys
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk

class FormWindow(Gtk.Window):
    def __init__(self):
        super().__init__(title="Run")
        self.set_border_width(16)
        self.set_position(Gtk.WindowPosition.MOUSE)

        # グリッドの作成
        grid = Gtk.Grid()
        grid.set_column_spacing(16)
        grid.set_row_spacing(16)
        self.add(grid)

        ICON = Gtk.Image()
        print(os.path.dirname(__file__)+"/ICON.png")
        ICON.set_from_file(os.path.dirname(__file__)+"/ICON.png")
        grid.attach(ICON, 0, 0, 1, 1)

        TOP_LABEL = Gtk.Label(label="Type the name of a program, and I will open it\rfor you.")
        grid.attach(TOP_LABEL, 1, 0, 3, 1)

        OPEN_LABEL = Gtk.Label(label="Open:")
        grid.attach(OPEN_LABEL, 0, 1, 1, 1)

        self.COMMAND = Gtk.Entry()
        grid.attach(self.COMMAND, 1, 1, 3, 1)

        # ボタン
        OK_BUTTON = Gtk.Button(label="OK")
        OK_BUTTON.connect("clicked", self.OK)
        grid.attach(OK_BUTTON, 1, 2, 1, 1)

        CANCEL_BUTTON = Gtk.Button(label="Cancel")
        CANCEL_BUTTON.connect("clicked", self.CANCEL)
        grid.attach(CANCEL_BUTTON, 2, 2, 1, 1)

        BROWSE_BUTTON = Gtk.Button(label="Browse...")
        BROWSE_BUTTON.connect("clicked", self.BROWSE)
        grid.attach(BROWSE_BUTTON, 3, 2, 1, 1)

    def OK(self, widget):
        print(self.COMMAND.get_text())
        subprocess.Popen(str(self.COMMAND.get_text()), shell=True)
        sys.exit()
    def CANCEL(self, widget):
        sys.exit()
    def BROWSE(self, widget):
        print("NOTHING YET!!!!")

win = FormWindow()
win.connect("destroy", Gtk.main_quit)
win.show_all()
Gtk.main()
