    // 不定形リージョンウィンドウ作成
    // 画像データ使用バージョン
    // pget & CreateRectRgnに比べれば高速
 
    // 必要なものをインクルード
    #include "user32.as"
    #include "gdi32.as"
    #include "winmm.as"    // これはリージョン作成に直接関係無し
 
    // ウィンドウ移動制御用の定数
    #define global WM_NCLBUTTONDOWN     $000000A1
    #define global HTCAPTION            2
 
    // モジュール記述
    #module
 
    // CreateWindowRgn p1(targetWin), p2(baseWin)
    // targetWin : 不定形リージョンを適用するウィンドウID
    // baseWin   : 不定形リージョンを作成する絵があるウィンドウID
    #deffunc CreateWindowRgn int targetWin, int baseWin
 
    gsel baseWin
    
    mref vram, 66    // 画像データを取得
    
    wx = ginfo_winx : wy = ginfo_winy    // 画像サイズ取得
 
    ;pget 0, 0        // 透明色の取得（点（０，０）の色を透明色にする）
    ;tr = ginfo_r : tg = ginfo_g : tb = ginfo_b
	tr=255 :tg=0 :tb=255	;桃色を透明色にする
 
    CreateRectRgn 0, 0, 0, 0    // 空のリージョンを用意
    tmpRgn = stat
 
    // 変数初期化
    // 注：yは画像データの構造上、下から。
    x = 0 : y = wy : flg = 0 : count = 0
    repeat wy
        repeat wx
            // 画像データの構造にそってRGB値を取得
            b = peek(vram,count)
            count++
            g = peek(vram,count)
            count++
            r = peek(vram,count)
            count++
            
            // 透明色と比較
            if (wx == x + 1) | ((r == tr) && (g == tg) && (b == tb)) {
                if flg == 1 {
                    CreateRectRgn sx, y - 1, x, y    // 下からスキャンなのでこうなる
                    gRgn = stat
                    CombineRgn tmpRgn, tmpRgn, gRgn, 2    // 空っぽのリージョンと結合
                    DeleteObject gRgn                 // 作ったら消す。一番の無駄処理
                    flg = 0                // フラグを元に戻す
                }
            } else {
                if flg == 0 : sx = x : flg = 1    // フラグ立てずに済む方法プリーズ
            }
            x++
        loop
        x = 0
        y--
    loop
    
    gsel targetWin            // ターゲットウィンドウをアクティブに
    SetWindowRgn hwnd, tmpRgn, 1    // リージョン設定
    DeleteObject tmpRgn        // 後片付け
    
    return
    
    #global
